Rough.plow.gamma <-
function( y=c(20,30), ylow=c(10,20), conf.level=.95 )
{ gamma=y
  n = sum(y)
  nl = sum(ylow)
  for (i in 1:length(y))
  { gamma[i] = (nl - ylow[i]) / (n - y[i])
  }
  p = ylow/y
  diff = p / gamma
  fraction = diff
  
  a = ylow / n
  b = (y - ylow) / n 
  c = a
  for (i in 1:length(y))
  { c[i] = (nl - ylow[i])/n
  }

  var = 1/n * (b*c*(1-b) +a*b*(1-b-2*c) + a^2*(1-2*b-c)-a^3) / (a*c*(1-a-b)*(a+b))
  se = sqrt(var)

  z=qnorm(1-(1-conf.level)/2)
  fraction.low = exp( log(diff) - z*se)
  fraction.up  = exp( log(diff) + z*se)
  retval = cbind(p, gamma, fraction, fraction.low, fraction.up, se, var)
  return (retval)
}
