Rough.alpha.2C <-
function(n=60, yupp=20, ylow=10, zupp=c(20), zlow=c(10), overlap=c(5), conf.level=.95 )
{ alphay = ylow/yupp 
  alphaz = zlow/zupp
  diff = alphay / alphaz
  fraction = diff
  a=ylow/n
  b=overlap/n
  c=(yupp - overlap - ylow)/n
  d=zlow/n
  e=(zupp - overlap - zlow)/n
  var = 1/n* (a^2*(b+e)+(b+c)*d*(b+d+e)+a*(b^2+c*e+b*(c-2*d+e))) / ( a*(a+b+c)*d*(b+d+e) )
  se = sqrt(var)
  zq=qnorm(1-(1-conf.level)/2)
  fraction.low = exp( log(diff) - zq*se)
  fraction.up  = exp( log(diff) + zq*se)
  retval = cbind(alphay, alphaz, fraction, fraction.low, fraction.up, se, var)
  return (retval)
}
